/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Stack;
import org.experlog.gencode.ExpEval;
import org.experlog.gencode.ExpOperand;

public class ExpParser {
    String theString_ = null;
    PushbackReader str_;
    double currentValue_;
    String currentStringValue_;
    int currentValueType_ = 0;
    int previousToken_ = -1;
    public boolean evalexpr_ = true;
    public static final int EOL = 0;
    public static final int VALUE = 1;
    public static final int OPAR = 2;
    public static final int CPAR = 3;
    public static final int EXP = 4;
    public static final int MULT = 5;
    public static final int DIV = 6;
    public static final int PLUS = 7;
    public static final int MINUS = 8;
    public static final int AND = 9;
    public static final int OR = 10;
    public static final int NOT = 11;
    public static final int EQUAL = 12;
    public static final int DIFF = 13;
    public static final int GT = 14;
    public static final int LT = 15;
    public static final int GE = 16;
    public static final int LE = 17;
    public static final int UMINUS = 18;
    Stack stack_ = new Stack();
    String warning_ = null;

    public ExpParser(String s) {
        this(s, true);
    }

    public ExpParser(String s, boolean evalexpr) {
        this.evalexpr_ = evalexpr;
        this.theString_ = s;
        if (s == null || s.trim().length() < 1) {
            this.str_ = null;
            this.theString_ = null;
        } else {
            this.str_ = new PushbackReader(new StringReader(s), 2);
        }
    }

    public void setWarning(String w) {
        this.warning_ = w;
    }

    public String getWarning() {
        String w = null;
        if (this.warning_ != null) {
            w = new String(this.warning_);
            this.warning_ = null;
        }
        return w;
    }

    public void setEvalExpr(boolean eval) {
        this.evalexpr_ = eval;
    }

    public String getRawString() {
        return this.theString_;
    }

    public ExpOperand buildFormula(int minsize) throws IOException {
        ExpOperand opleft;
        int operator;
        ExpOperand opright;
        if (this.str_ == null) {
            return null;
        }
        int preccrt = -1;
        int tok = -1;
        do {
            if ((tok = this.getToken()) == 0 || tok == 3) continue;
            if (tok == 2) {
                this.stack_.push(this.buildFormula(this.stack_.size() + 1));
                continue;
            }
            if (tok != 1 && this.getPrecedence(tok) <= preccrt) {
                if (!this.isUnary(tok)) {
                    try {
                        opright = this.toOperand(this.stack_.pop());
                        operator = this.toOperator(this.stack_.pop());
                        opleft = null;
                        if (!this.isUnary(operator)) {
                            opleft = this.toOperand(this.stack_.pop());
                        }
                        this.stack_.push(new ExpOperand(operator, opleft, opright));
                    }
                    catch (Exception e) {
                        this.stack_.empty();
                        throw new IOException("Parse error during evaluation");
                    }
                }
                this.stack_.push(new Integer(tok));
                preccrt = this.getPrecedence(tok);
                continue;
            }
            if (tok == 1) {
                if (this.currentValueType_ == 0) {
                    this.stack_.push(new Double(this.currentValue_));
                    continue;
                }
                this.stack_.push(this.currentStringValue_);
                continue;
            }
            this.stack_.push(new Integer(tok));
            preccrt = this.getPrecedence(tok);
        } while (tok != 0 && tok != 3);
        while (this.stack_.size() > minsize) {
            try {
                opright = this.toOperand(this.stack_.pop());
                operator = this.toOperator(this.stack_.pop());
                opleft = null;
                if (!this.isUnary(operator)) {
                    opleft = this.toOperand(this.stack_.pop());
                }
                this.stack_.push(new ExpOperand(operator, opleft, opright));
            }
            catch (Exception e) {
                this.stack_.empty();
                throw new IOException("Parse error during evaluation");
            }
        }
        try {
            return this.toOperand(this.stack_.pop());
        }
        catch (Exception e) {
            this.stack_.empty();
            throw new IOException("Parse error during evaluation");
        }
    }

    public boolean isUnary(int operator) {
        return operator == 11 || operator == 18;
    }

    public int getToken() throws IOException {
        int tok;
        int c = this.str_.read();
        while (c == 32 || c == 9) {
            c = this.str_.read();
        }
        if (c < 0) {
            this.str_.close();
            return 0;
        }
        if (c == 39) {
            StringBuffer sb = new StringBuffer();
            boolean go = true;
            while (go && c >= 0) {
                c = this.str_.read();
                if (c == 39) {
                    int next = this.str_.read();
                    boolean bl = go = next == 39;
                    if (!go) {
                        if (next < 0) continue;
                        this.str_.unread(next);
                        continue;
                    }
                    sb.append('\'');
                    continue;
                }
                sb.append((char)c);
            }
            if (go && c < 0) {
                this.str_.close();
                return 0;
            }
            this.currentStringValue_ = sb.toString();
            this.currentValueType_ = 1;
            tok = 1;
        } else if (c == 94) {
            tok = this.extractString("^") ? 1 : 4;
        } else if (c == 47) {
            tok = this.extractString("/") ? 1 : 6;
        } else if (c == 42) {
            tok = this.extractString("*") ? 1 : 5;
        } else if (c == 40) {
            tok = 2;
        } else if (c == 41) {
            tok = 3;
        } else if (c == 43) {
            tok = this.extractString("+") ? 1 : 7;
        } else if (c == 45) {
            tok = this.extractString("-") ? 1 : (this.previousToken_ == 1 || this.previousToken_ == 3 ? 8 : 18);
        } else if (this.evalexpr_ && c == 35) {
            tok = 13;
        } else if (this.evalexpr_ && c == 38) {
            int nextc = this.str_.read();
            if (nextc == 38) {
                tok = 9;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 9;
            }
        } else if (this.evalexpr_ && c == 124) {
            int nextc = this.str_.read();
            if (nextc == 124) {
                tok = 10;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 10;
            }
        } else if (this.evalexpr_ && c == 61) {
            int nextc = this.str_.read();
            if (nextc == 61) {
                tok = 12;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 12;
            }
        } else if (this.evalexpr_ && c == 33) {
            int nextc = this.str_.read();
            if (nextc == 61) {
                tok = 13;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 11;
            }
        } else if (this.evalexpr_ && c == 62) {
            int nextc = this.str_.read();
            if (nextc == 61) {
                tok = 16;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 14;
            }
        } else if (this.evalexpr_ && c == 60) {
            int nextc = this.str_.read();
            if (nextc == 61) {
                tok = 17;
            } else {
                if (nextc >= 0) {
                    this.str_.unread(nextc);
                }
                tok = 15;
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append((char)c);
            while (!this.isOperatorChar(c = this.str_.read())) {
                sb.append((char)c);
            }
            if (sb.length() >= 2 && sb.charAt(sb.length() - 1) == 'E' && Character.isDigit(sb.charAt(sb.length() - 2))) {
                sb.append((char)c);
                while (!this.isOperatorChar(c = this.str_.read())) {
                    sb.append((char)c);
                }
            }
            if (c >= 0) {
                this.str_.unread(c);
            }
            String s = sb.toString().trim();
            try {
                this.currentValue_ = Double.parseDouble(s);
                this.currentValueType_ = 0;
            }
            catch (NumberFormatException e) {
                int lastpos = s.length() - 1;
                if (s.charAt(0) == '\'' && s.charAt(lastpos) == '\'') {
                    s = s.substring(1, lastpos);
                }
                this.currentStringValue_ = s;
                this.currentValueType_ = 1;
            }
            tok = 1;
        }
        this.previousToken_ = tok;
        return tok;
    }

    private boolean extractString(String prefix) throws IOException {
        int c = this.str_.read();
        if (c < 0) {
            this.currentStringValue_ = prefix;
            this.currentValueType_ = 1;
            this.setWarning("Dubious string without quotes in expression [" + this.theString_ + "]");
            return true;
        }
        if ("+*-/^".indexOf((char)c) < 0) {
            this.str_.unread(c);
            return false;
        }
        int cd = this.str_.read();
        if (Character.isDigit((char)cd)) {
            this.str_.unread(cd);
            this.str_.unread(c);
            return false;
        }
        StringBuffer sb = new StringBuffer(prefix);
        sb.append((char)c);
        while (("+*-/^".indexOf(c = this.str_.read()) >= 0 || c != 32 && c != 9 && !this.isOperatorChar(c)) && c >= 0) {
            sb.append((char)c);
        }
        if (c >= 0) {
            this.str_.unread(c);
        }
        this.currentStringValue_ = sb.toString().trim();
        this.currentValueType_ = 1;
        this.setWarning("Dubious string without quotes in expression [" + this.theString_ + "]");
        return true;
    }

    boolean isOperatorChar(int c) {
        if (c == -1) {
            return true;
        }
        if (this.evalexpr_) {
            return "+*-/^()&|!=><#".indexOf((char)c) >= 0;
        }
        return "+*-/^()".indexOf((char)c) >= 0;
    }

    public int toOperator(Object o) {
        return (Integer)o;
    }

    public ExpOperand toOperand(Object o) {
        if (o instanceof Double) {
            return new ExpOperand((Double)o);
        }
        if (o instanceof String) {
            return new ExpOperand((String)o);
        }
        return (ExpOperand)o;
    }

    public int getPrecedence(int token) {
        switch (token) {
            case 10: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return 10;
            }
            case 7: 
            case 8: {
                return 11;
            }
            case 5: 
            case 6: {
                return 12;
            }
            case 4: {
                return 13;
            }
            case 18: {
                return 14;
            }
            case 11: {
                return 15;
            }
        }
        return 0;
    }

    public static String opString(int op) {
        switch (op) {
            case 4: {
                return "^";
            }
            case 5: {
                return "*";
            }
            case 6: {
                return "/";
            }
            case 7: {
                return "+";
            }
            case 8: {
                return "-";
            }
            case 9: {
                return "&&";
            }
            case 10: {
                return "||";
            }
            case 11: {
                return "!";
            }
            case 12: {
                return "==";
            }
            case 13: {
                return "#";
            }
            case 14: {
                return ">";
            }
            case 15: {
                return "<";
            }
            case 16: {
                return ">=";
            }
            case 17: {
                return "<=";
            }
            case 18: {
                return "-";
            }
        }
        return "?";
    }

    public ExpOperand parse() throws IOException {
        return this.buildFormula(1);
    }

    public static void main(String[] args) throws Exception {
        String formula;
        BufferedReader reader = args.length > 0 ? new BufferedReader(new FileReader(args[0])) : new BufferedReader(new InputStreamReader(System.in));
        while ((formula = reader.readLine()) != null) {
            System.out.print("INPUT: " + formula);
            ExpParser parser = new ExpParser(formula, false);
            ExpOperand result = parser.parse();
            System.out.print(" PARSE TREE: " + (result == null ? "null" : result.toString()));
            ExpEval eval = new ExpEval();
            System.out.println(" EVAL: " + eval.eval(result));
        }
    }
}

