/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Category;
import org.enhydra.jdbc.standard.StandardStatement;
import org.experlog.db.ESDBDataTuple;
import org.experlog.openeas.api.DataObject;
import org.experlog.openeas.api.DataSet;
import org.experlog.util.Client;
import org.experlog.util.ESCategory;

public class ESDBDataSet
implements DataSet {
    String table_ = null;
    ResultSet rset_ = null;
    int low_ = 1;
    int high_ = -1;
    int idx_ = 0;
    boolean first_ = true;
    boolean hasresults_ = false;
    boolean cacheRS_ = false;
    Connection con_ = null;
    Client session_ = null;
    String datasourcename_ = null;
    Category logger_ = null;
    Statement stat_ = null;

    public ESDBDataSet(ResultSet rs, Client session, Connection con, String datasourcename, Statement stat) throws SQLException {
        this.logger_ = ESCategory.getCategory(session == null ? null : session.getAppName(), "openeas.db");
        this.con_ = con;
        this.rset_ = rs;
        this.stat_ = stat;
        this.logger_.debug((Object)("ESDBDataSet:RSET " + this.stat_.toString()));
        this.session_ = session;
        this.datasourcename_ = datasourcename;
        ResultSetMetaData md = this.rset_.getMetaData();
        if (md != null) {
            this.table_ = md.getTableName(1);
        }
        try {
            this.hasresults_ = this.rset_.next();
        }
        catch (Exception e) {
            this.hasresults_ = false;
        }
        if (this.hasresults_) {
            this.idx_ = 1;
        }
        this.cacheRS_ = this.session_.cacheRS();
    }

    public boolean next() throws SQLException {
        this.logger_.debug((Object)"ESDBDataSet:next");
        if (!this.hasresults_) {
            return false;
        }
        if (this.high_ > 0 && this.idx_ > this.high_) {
            this.hasresults_ = false;
            return false;
        }
        if (this.first_) {
            this.first_ = false;
        } else {
            try {
                if (this.hasresults_) {
                    this.hasresults_ = this.rset_.next();
                }
            }
            catch (Exception e) {
                this.hasresults_ = false;
            }
        }
        if (this.hasresults_) {
            ++this.idx_;
        }
        return this.hasresults_;
    }

    public boolean dataAvailable() throws SQLException {
        this.logger_.debug((Object)"ESDBDataSet:dataAvailable");
        return this.hasresults_;
    }

    public DataObject getTuple() throws SQLException {
        this.logger_.debug((Object)"ESDBDataSet:getTuple");
        return new ESDBDataTuple(this.rset_, this.cacheRS_);
    }

    public void open() throws SQLException {
    }

    public void close() throws SQLException {
        this.logger_.debug((Object)"ESDBDataSet:close in");
        try {
            if (this.rset_ != null) {
                this.logger_.debug((Object)"ESDBDataSet:close the resultset");
                if (this.stat_ instanceof StandardStatement) {
                    StandardStatement sstat = (StandardStatement)this.stat_;
                    this.logger_.debug((Object)"ESDBDataSet:close is instance of CoreStatement");
                    if (!sstat.getInCache()) {
                        if (this.rset_ != null) {
                            this.logger_.debug((Object)("ESDBDataSet:close is not in cache " + this.stat_.toString()));
                            this.rset_.close();
                        }
                        if (this.stat_ != null) {
                            this.logger_.debug((Object)"ESDBDataSet:close the statement 1");
                            this.stat_.close();
                        }
                    } else {
                        this.logger_.debug((Object)"ESDBDataSet:close open the statement");
                        this.open();
                    }
                } else {
                    this.rset_.close();
                    if (this.stat_ != null) {
                        this.logger_.debug((Object)("ESDBDataSet:close the statement 2 " + this.stat_.toString()));
                        this.stat_.close();
                    }
                }
            }
            this.logger_.debug((Object)"ESDBDataSet:close out1");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (this.session_ != null) {
                this.logger_.debug((Object)"ESDBDataSet:close the connection");
                this.session_.closeConnection(this.con_, this.datasourcename_);
            }
            this.rset_ = null;
            this.con_ = null;
            this.idx_ = 0;
            this.high_ = -1;
            this.low_ = 0;
            this.logger_.debug((Object)"ESDBDataSet:close out2");
        }
    }

    public void setBoundaries(int low, int high) throws SQLException {
        if (low <= 0) {
            low = 1;
        }
        this.low_ = low;
        this.high_ = high;
        while (this.idx_ < low && this.next()) {
        }
    }

    public boolean isTransient() {
        return true;
    }

    public ResultSet getResultSet() {
        this.logger_.debug((Object)"ESDBDataSet:getResultSet");
        return this.rset_;
    }
}

