/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.enhydra.jdbc.pool.GenerationObject;
import org.experlog.db.DatasourceProperty;
import org.experlog.db.ESDataSourceWrapper;
import org.experlog.openeas.api.ConnectionManager;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Configuration;
import org.experlog.util.ConnectionPool;
import org.experlog.util.ESCategory;

public class ESConnectionPool
implements ConnectionPool {
    private boolean new_ = true;
    private AppConfiguration shopConfig_ = null;
    private int qryattempts_ = 1;
    private boolean reconnect_on_err_ = false;
    private ESDataSourceWrapper dataSource_;
    private Category logger;
    private Hashtable datasources;

    public void setShopConfig(Configuration shopConfig, String name) throws Exception {
        this.logger = ESCategory.getCategory(name, "openeas.db");
        this.logger.debug((Object)"ESConnectionPool:setShopConfig set the shop config for this object");
        this.shopConfig_ = (AppConfiguration)shopConfig;
        if (this.dataSource_ == null) {
            this.dataSource_ = new ESDataSourceWrapper(name);
            this.dataSource_.init(this.shopConfig_, null);
            ConnectionManager.addDataSource(this.dataSource_);
            if (shopConfig != null) {
                this.datasources = new Hashtable();
                Hashtable htable = shopConfig.getDatasources();
                if (htable != null) {
                    this.logger.debug((Object)"There are datasources to configure, configure them now");
                    for (DatasourceProperty dsprop : htable.values()) {
                        this.logger.debug((Object)("add the following datasource=<" + dsprop.getName() + ">"));
                        ESDataSourceWrapper esds = new ESDataSourceWrapper(name);
                        this.logger.debug((Object)"init the ESDataSourceWrapper with the shopConfig and the DatasourceProperty");
                        esds.init(this.shopConfig_, dsprop);
                        ConnectionManager.addDataSource(esds);
                        esds.setMinCon(dsprop.getMinConn());
                        esds.setMaxCon(dsprop.getMaxConn());
                        this.datasources.put(dsprop.getName(), esds);
                        this.logger.debug((Object)"add the new ESDataSourceWrapper to the Administration center");
                    }
                }
            }
        } else {
            this.logger.error((Object)"ESConnectionPool:setShopConfig ERROR: try to set again the shop config property");
        }
        this.dataSource_.setMinCon(this.shopConfig_.getMinConn());
        this.dataSource_.setMaxCon(this.shopConfig_.getMaxConn());
    }

    public synchronized Connection connectDb(String datasourcename) throws Exception {
        this.logger.debug((Object)"ESConnectionPool:connectionDb load the Jdbc driver ");
        Connection c = null;
        if (this.new_) {
            String open2 = this.shopConfig_.get("jdbc.PreOpen");
            if (open2 != null && open2.equalsIgnoreCase("true")) {
                if (datasourcename == null) {
                    this.logger.debug((Object)"connectionDb just get a connection");
                    c = this.dataSource_.getConnection(this.shopConfig_.getJdbcUser(), this.shopConfig_.getJdbcPassword());
                    this.logger.debug((Object)"connectionDb just release this connection (close)");
                    c.close();
                } else {
                    this.logger.debug((Object)("New_, the datasource is <" + datasourcename + ">"));
                    Hashtable htable = this.shopConfig_.getDatasources();
                    DatasourceProperty esds = (DatasourceProperty)htable.get(datasourcename);
                    c = ((ESDataSourceWrapper)this.datasources.get(datasourcename)).getConnection(esds.getUser(), esds.getPassword());
                    this.logger.debug((Object)"New_ end, the connection is released");
                    c.close();
                }
            }
            this.new_ = false;
        }
        this.logger.debug((Object)"ESConnectionPool:connectionDb call the getConnection method on DataSource");
        if (datasourcename == null) {
            this.logger.debug((Object)"the name of the datasource is null, default status");
            c = this.dataSource_.getConnection(this.shopConfig_.getJdbcUser(), this.shopConfig_.getJdbcPassword());
            this.setTxIsolation(c, this.shopConfig_.getJdbcTxIsolation());
        } else {
            this.logger.debug((Object)"the name of the datasource is not null, try to get a new connection from it");
            Hashtable htable = this.shopConfig_.getDatasources();
            DatasourceProperty esds = (DatasourceProperty)htable.get(datasourcename);
            this.logger.debug((Object)("get a connection from a datasource (hashtable) <" + datasourcename + "> from client=<" + esds.getUser() + ">"));
            c = ((ESDataSourceWrapper)this.datasources.get(datasourcename)).getConnection(esds.getUser(), esds.getPassword());
            this.setTxIsolation(c, esds.getTxIsolation());
        }
        if (c == null) {
            this.logger.debug((Object)"ESConnectionPool:connectionDb return an invalid connection");
        } else {
            this.logger.debug((Object)"ESConnectionPool:connectionDb return a valid connection");
        }
        return c;
    }

    public void updateDB(Connection con, String sql) throws SQLException {
        this.logger.debug((Object)"ESConnectionPool:updateDb update the store's database");
        Statement st = null;
        try {
            st = con.createStatement();
        }
        catch (SQLException nc) {
            this.logger.error((Object)("[" + new Date(System.currentTimeMillis()) + "] ERROR IN createStatement, sql=[" + sql + "] "), (Throwable)nc);
            throw nc;
        }
        this.logger.debug((Object)("ESConnectionPool:updateDB SESSION updateDB: sql=" + sql));
        try {
            st.executeUpdate(sql);
        }
        catch (SQLException nc) {
            this.logger.error((Object)("[" + new Date(System.currentTimeMillis()) + "] ERROR IN executeUpdate, sql=[" + sql + "] "), (Throwable)nc);
            throw nc;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public int getQryattempts() {
        return this.qryattempts_;
    }

    public boolean isReconnect_on_err() {
        return this.reconnect_on_err_;
    }

    public boolean isNew() {
        return this.new_;
    }

    public ESDataSourceWrapper getDataSource() {
        return this.dataSource_;
    }

    public void setQryattempts(int qryattempts) {
        this.qryattempts_ = qryattempts;
    }

    public void setReconnect_on_err(boolean reconnect) {
        this.reconnect_on_err_ = reconnect;
    }

    public void setNew(boolean newb) {
        this.new_ = newb;
    }

    public synchronized void cleanup() {
        this.dataSource_.cleanup();
        if (this.datasources != null) {
            for (ESDataSourceWrapper esdw : this.datasources.values()) {
                esdw.cleanup();
            }
        }
    }

    private void setTxIsolation(Connection c, int txisol) {
        if (txisol == -32767 || c == null) {
            return;
        }
        try {
            this.logger.debug((Object)("Setting connection's TX isolation to: " + txisol));
            c.setTransactionIsolation(txisol);
        }
        catch (SQLException e) {
            this.logger.debug((Object)"Warning: Could not set TX isolation (ignored).");
        }
    }

    public Hashtable getPool() {
        return this.dataSource_.getPool();
    }

    public void removeUnlockedObject(GenerationObject obj) {
        this.dataSource_.removeUnlockedObject(obj);
    }

    public Hashtable getUsedPool() {
        return this.dataSource_.getUsedPool();
    }

    public void removeLockedObject(GenerationObject obj) {
        this.dataSource_.removeLockedObject(obj);
    }
}

