/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.base;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;
import org.experlog.base.ESAction;
import org.experlog.base.ESCookie;
import org.experlog.base.ESServletRequest;
import org.experlog.base.ESStore;
import org.experlog.base.OpenClient;
import org.experlog.gencode.ESDynHtml;
import org.experlog.util.ESCategory;
import org.experlog.util.ESHttpUtils;

public class ESServlet
extends HttpServlet {
    private static final long serialVersionUID = -3776044759938057487L;
    private boolean actionStatus_ = true;
    private boolean autoconnect_ = true;
    public Category logger;

    public void init(ServletConfig cfg) throws ServletException {
        try {
            super.init(cfg);
            this.logger = ESCategory.getCategory("openeas.servlet");
            this.logger.debug((Object)"configure");
            ESStore.getInstance(cfg);
        }
        catch (Exception e) {
            this.logger = ESCategory.getCategory("openeas.servlet");
            this.logger.error((Object)("ESServlet:init Exception " + e));
            throw new ServletException(e.getMessage());
        }
    }

    public void setAutoconnect(boolean ac) {
        this.autoconnect_ = ac;
    }

    public void setNoStore(HttpServletResponse res) {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-store");
        res.setDateHeader("Expires", 0L);
    }

    public void setNoContent(HttpServletResponse res) {
        res.setStatus(204);
    }

    public void setNotModified(HttpServletResponse res) {
        res.setStatus(304);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        OpenClient session = null;
        try {
            String contentType;
            res.setStatus(200);
            if (this.autoconnect_) {
                String sessionid = ESHttpUtils.getSessionId(req);
                session = ESStore.getInstance().getClient(sessionid, req);
            }
            if ((contentType = req.getParameter("ContentType")) != null) {
                res.setContentType(ESStore.getInstance().getShopConfiguration().getContentType(contentType));
            } else {
                res.setContentType("text/html");
            }
            String httpStatus = req.getParameter("http.Status");
            if (httpStatus != null) {
                try {
                    res.setStatus(Integer.parseInt(httpStatus));
                }
                catch (Exception e) {
                    res.setStatus(200);
                }
            }
            ESServletRequest ereq = new ESServletRequest(req, res, session);
            this.logger = ESCategory.getCategory("openeas.servlet");
            this.logger.debug((Object)("ESServlet:doGet session=<" + session + ">"));
            if (session != null) {
                Hashtable<String, String> param = new Hashtable<String, String>();
                Enumeration enu = req.getParameterNames();
                while (enu.hasMoreElements()) {
                    String cl = (String)enu.nextElement();
                    param.put(cl, req.getParameter(cl));
                }
                session.setParam(param);
                if (session.getAppConfiguration().useCookies()) {
                    HttpSession hs = req.getSession();
                    hs.setMaxInactiveInterval(session.getAppConfiguration().getCookieTimeout());
                    ((ESCookie)session.getCookie()).fromHttpSession(hs, session.getAppConfiguration(), req, res);
                }
                session.resetTimer();
                if (session.multithread()) {
                    this.sget(session, ereq, res, true);
                } else {
                    this.syncsget(session, ereq, res, true);
                }
                if (session.getAppConfiguration().useCookies()) {
                    ((ESCookie)session.getCookie()).toHttpSession(req.getSession());
                }
            } else {
                this.sget(session, ereq, res, true);
            }
        }
        catch (Exception e) {
            this.printException("GET", e, res);
        }
    }

    public void getRequest(OpenClient session, ESServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger = ESCategory.getCategory("openeas.servlet");
        this.logger.warn((Object)"ESServlet:getRequest WARNING: ESServlet.getRequest() not overridden");
    }

    public void postRequest(OpenClient session, ESServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger = ESCategory.getCategory("openeas.servlet");
        this.logger.warn((Object)"WARNING: ESServlet.postRequest() not overridden");
    }

    public void sget(OpenClient session, ESServletRequest ereq, HttpServletResponse res, boolean get) throws Exception {
        this.actionStatus_ = true;
        String action = ereq.getParameter("Action");
        if (action != null) {
            ESAction act = (ESAction)Class.forName(action).newInstance();
            if (act.serverSide()) {
                throw new ServletException("ACCESS DENIED: " + action + " is a server-side only action");
            }
            this.logger = ESCategory.getCategory("openeas.servlet");
            this.logger.debug((Object)("ESServlet:sget " + act.toString()));
            this.actionStatus_ = act.processRequest(session, ereq, null, null);
        }
        if (session != null) {
            ((ESCookie)session.getCookie()).setCookie(ereq);
        }
        if (get) {
            this.getRequest(session, ereq, res);
        } else {
            this.postRequest(session, ereq, res);
        }
    }

    public synchronized void syncsget(OpenClient session, ESServletRequest ereq, HttpServletResponse res, boolean get) throws Exception {
        this.sget(session, ereq, res, get);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        OpenClient session = null;
        try {
            String contentType;
            res.setStatus(200);
            if (this.autoconnect_) {
                String sessionid = ESHttpUtils.getSessionId(req);
                session = ESStore.getInstance().getClient(sessionid, req);
            }
            if ((contentType = req.getParameter("ContentType")) != null) {
                res.setContentType(ESStore.getInstance().getShopConfiguration().getContentType(contentType));
            } else {
                res.setContentType("text/html");
            }
            String httpStatus = req.getParameter("http.Status");
            if (httpStatus != null) {
                try {
                    res.setStatus(Integer.parseInt(httpStatus));
                }
                catch (Exception e) {
                    res.setStatus(200);
                }
            }
            ESServletRequest ereq = new ESServletRequest(req, res, session);
            this.logger = ESCategory.getCategory("openeas.servlet");
            this.logger.debug((Object)("ESServlet:doGet session=<" + session + ">"));
            if (session != null) {
                Hashtable<String, String> param = new Hashtable<String, String>();
                Enumeration enu = req.getParameterNames();
                while (enu.hasMoreElements()) {
                    String cl = (String)enu.nextElement();
                    param.put(cl, req.getParameter(cl));
                }
                session.setParam(param);
                if (session.getAppConfiguration().useCookies()) {
                    HttpSession hs = req.getSession();
                    hs.setMaxInactiveInterval(session.getAppConfiguration().getCookieTimeout());
                    ((ESCookie)session.getCookie()).fromHttpSession(hs, session.getAppConfiguration(), req, res);
                }
                session.resetTimer();
                if (session.multithread()) {
                    this.sget(session, ereq, res, true);
                } else {
                    this.syncsget(session, ereq, res, true);
                }
                if (session.getAppConfiguration().useCookies()) {
                    ((ESCookie)session.getCookie()).toHttpSession(req.getSession());
                }
            } else {
                this.sget(session, ereq, res, true);
            }
        }
        catch (Exception e) {
            this.printException("POST", e, res);
        }
    }

    public boolean actionFailed() {
        return !this.actionStatus_;
    }

    public void printException(String type, Exception e, HttpServletResponse res) throws IOException {
        System.err.println("[" + new Date(System.currentTimeMillis()) + "] ERROR IN ESSservlet (" + type + "), sending msg to the user's Web Browser");
        e.printStackTrace(System.err);
        if (ESStore.getInstance().getShopConfiguration().getOfftmpl() != null) {
            PrintWriter out = res.getWriter();
            out.println("<HTML><BODY>");
            ESDynHtml expander = new ESDynHtml(null, new File(ESStore.getInstance().getShopConfiguration().getOfftmpl()));
            try {
                expander.expand(out);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            out.println("</BODY></HTML>");
        }
    }
}

